//
//  FJDPersistentWindowController.h
//  FJDCoreDataWindow
//
//  Created by FUJIDANA on 06/08/17.
//  Copyright 2006 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface FJDPersistentWindowController : NSWindowController
{
	@private
    NSPersistentStoreCoordinator *_persistentStoreCoordinator;
    NSManagedObjectModel         *_managedObjectModel;
    NSManagedObjectContext       *_managedObjectContext;
	NSURL                        *_pStoreURL;
	NSString                     *_pStoreType;
}

#pragma mark Class methods
+ (NSURL *)URLWithPersistentStoreDirectory:(NSString *)directory filename:(NSString *)filename;

#pragma mark Initializing methods
- (id)initWithWindow:(NSWindow *)window URLForPersistentStore:(NSURL *)url storeType:(NSString *)storeType;
- (id)initWithWindowNibName:(NSString *)windowNibName URLForPersistentStore:(NSURL *)url storeType:(NSString *)storeType;
- (id)initWithWindowNibName:(NSString *)windowNibName owner:(id)owner URLForPersistentStore:(NSURL *)url storeType:(NSString *)storeType;
- (id)initWithWindowNibPath:(NSString *)windowNibPath owner:(id)owner URLForPersistentStore:(NSURL *)url storeType:(NSString *)storeType;

#pragma mark Accessor mthods
- (NSPersistentStoreCoordinator *)persistentStoreCoordinator;
- (NSManagedObjectModel *)managedObjectModel;
- (NSManagedObjectContext *)managedObjectContext;

#pragma mark Action methods
- (IBAction)saveAction:sender;
- (IBAction)revertAction:(id)sender;

#pragma mark Methods implementing NSToolbarItemValidation informal protocol
- (BOOL)validateToolbarItem:(NSToolbarItem *)theItem;

#pragma mark Methods implementing NSMenuValidation informal protocol
- (BOOL)validateMenuItem:(id <NSMenuItem>)menuItem; 

@end
